--> pralable
-- USE BD_Air_France;

/* GROUPEMENTS */

CREATE TABLE T_pilote_pil
 (pil_brevet VARCHAR(6),pil_prenom VARCHAR(15),
  pil_nom VARCHAR(15), pil_hvol DECIMAL(7,2), avi_typavi CHAR(4), 
  pil_prime DECIMAL(5,2), pil_embauche DATE, cmp_compa VARCHAR(4),
  CONSTRAINT PK_pil PRIMARY KEY(pil_brevet));

INSERT INTO T_pilote_pil VALUES ('PL-1','Pierre','Filloux'    ,450    ,'A320',500 ,DATEFROMPARTS(1985,06,22),'AF');
INSERT INTO T_pilote_pil VALUES ('PL-2','Christian','Sigaudes',8700.50,'A320',NULL,DATEFROMPARTS(1995,05,13),'AF');
INSERT INTO T_pilote_pil VALUES ('PL-3','Pierre','Perez'      ,5600,   'A320',NULL,DATEFROMPARTS(2001,09,12),'SING');
INSERT INTO T_pilote_pil VALUES ('PL-4','Romaric','Benech'    ,2450,   'A330',500 ,DATEFROMPARTS(2001,09,21),'CAST');
INSERT INTO T_pilote_pil VALUES ('PL-5','Vincent','Gindre'    ,5605,   'A340',600 ,DATEFROMPARTS(1995,01,16),'SING');
INSERT INTO T_pilote_pil VALUES ('PL-6','Bruno','Duffau'      ,NULL,   'A340',0   ,DATEFROMPARTS(2001,09,21),'CAST');

SELECT AVG(pil_hvol) AS "Moyenne heures", 
       AVG(pil_prime) AS "Moyenne primes", AVG(ISNULL(pil_prime,0)) AS "Moyenne primes nette"
FROM   T_pilote_pil 
WHERE  cmp_compa = 'AF';

SELECT  COUNT(*) AS "COUNT(*)",
        COUNT(cmp_compa)          AS "COUNT(cmp_compa)", 
        COUNT(DISTINCT cmp_compa) AS "COUNT(DISTINCT cmp_compa)"
FROM    T_pilote_pil ;

SELECT MAX(pil_hvol) AS "Max hvol", MAX(pil_embauche) "Embauche rcente", 
       MIN(pil_prime) AS "Min prime", MIN(pil_embauche) "Embauche ancienne" 
FROM   T_pilote_pil;

-- groupements simples

SELECT   cmp_compa AS "Compagnie", COUNT(pil_brevet) AS "Nb pilotes" 
FROM     T_pilote_pil
GROUP BY (cmp_compa);

SELECT   cmp_compa cp, COUNT(pil_brevet) nbp
FROM     T_pilote_pil
GROUP BY (cmp_compa);

/*
SELECT   cmp_compa cp, COUNT(pil_brevet) nbp
FROM     T_pilote_pil
GROUP BY (nbp);
Msg207, Niveau16, tat1, Ligne...Nom de colonne non valide: 'nbp'.
*/

SELECT   cmp_compa AS "Compagnie", COUNT(pil_brevet) AS "Nombre pilotes", 
         AVG(pil_hvol) AS "Moyenne heures", 
         SUM(ISNULL(pil_prime,0)) AS "Somme des primes"
FROM     T_pilote_pil 
GROUP BY cmp_compa;

/*
SELECT   cmp_compa, avi_typavi, COUNT(pil_brevet) 
FROM     T_pilote_pil 
GROUP BY cmp_compa;
Msg8120, Niveau16, tat1, Ligne6
La colonne 'T_pilote_pil.avi_typavi' n'est pas valide dans la liste de slection parce qu'elle n'est pas contenue dans une fonction d'agrgation ou dans la clause GROUP BY.
*/

SELECT   cmp_compa AS "Compagnie", avi_typavi AS "Avion", COUNT(pil_brevet) AS "Nombre pilotes" 
FROM     T_pilote_pil 
GROUP BY cmp_compa, avi_typavi;

SELECT   cmp_compa AS "Compagnie", avi_typavi AS "Avion", COUNT(pil_brevet) AS "Nombre pilotes" 
FROM     T_pilote_pil 
GROUP BY cmp_compa, avi_typavi
HAVING   COUNT(pil_brevet) > 1;

-- CHECKSUM_AGG ( [ ALL | DISTINCT ] expression )  

DROP TABLE T_pilote_pil;
DROP TABLE dbo.T_vols_historique_vlh;

-- Fonctions avances de groupe

USE      BD_Air_France;

CREATE TABLE T_qualifs_qlf
 (qlf_brevet VARCHAR(6), qlf_annee DECIMAL(4,0),
  avi_typavi VARCHAR(4), cmp_compa VARCHAR(4));

INSERT INTO T_qualifs_qlf VALUES ('PL-1',2009,'A320','AF');
INSERT INTO T_qualifs_qlf VALUES ('PL-1',2009,'A330','AF');
INSERT INTO T_qualifs_qlf VALUES ('PL-1',2009,'A340','AF');

INSERT INTO T_qualifs_qlf VALUES ('PL-1',2010,'A330','AF');
INSERT INTO T_qualifs_qlf VALUES ('PL-1',2010,'A340','AF');

INSERT INTO T_qualifs_qlf VALUES ('PL-1',2011,'A380','AF');
INSERT INTO T_qualifs_qlf VALUES ('PL-1',2011,'A330','AF');
INSERT INTO T_qualifs_qlf VALUES ('PL-1',2011,'A340','AF');

INSERT INTO T_qualifs_qlf VALUES ('PL-2',2009,'A320','AF');
INSERT INTO T_qualifs_qlf VALUES ('PL-2',2009,'A340','AF');

INSERT INTO T_qualifs_qlf VALUES ('PL-2',2010,'A320','AF');

INSERT INTO T_qualifs_qlf VALUES ('PL-2',2011,'A320','AF');

INSERT INTO T_qualifs_qlf VALUES ('PL-3',2009,'A320','EJ');
INSERT INTO T_qualifs_qlf VALUES ('PL-3',2009,'A330','EJ');

INSERT INTO T_qualifs_qlf VALUES ('PL-3',2010,'A330','EJ');
INSERT INTO T_qualifs_qlf VALUES ('PL-3',2010,'A340','EJ');

INSERT INTO T_qualifs_qlf VALUES ('PL-3',2011,'A380','EJ');

-- GROUP BY ROLLUP(expression[,...])

SELECT   avi_typavi,qlf_annee,COUNT(qlf_brevet)
FROM     T_qualifs_qlf
GROUP BY avi_typavi,qlf_annee;

SELECT   avi_typavi,qlf_annee,COUNT(qlf_brevet) AS "Pilotes"
FROM     T_qualifs_qlf
GROUP BY ROLLUP(avi_typavi,qlf_annee);

SELECT   cmp_compa,avi_typavi,qlf_annee,COUNT(qlf_brevet) AS "Pilotes"
FROM     T_qualifs_qlf
GROUP BY cmp_compa,avi_typavi,qlf_annee;

SELECT   cmp_compa,avi_typavi,qlf_annee,COUNT(qlf_brevet) AS "Pilotes"
FROM     T_qualifs_qlf
GROUP BY ROLLUP(cmp_compa,avi_typavi,qlf_annee);

-- cmp_compa,avi_typavi,qlf_annee / cmp_compa,avi_typavi / cmp_compa

SELECT   cmp_compa,avi_typavi,qlf_annee,COUNT(qlf_brevet)
FROM     T_qualifs_qlf
GROUP BY ROLLUP (cmp_compa,avi_typavi),ROLLUP(qlf_annee);

-- cmp_compa,avi_typavi,qlf_annee / cmp_compa,avi_typavi / cmp_compa,qlf_annee / cmp_compa
-- / qlf_annee

-- GROUP BY CUBE(expression [,...])

SELECT   cmp_compa,avi_typavi,COUNT(qlf_brevet) AS "Pilotes"
FROM     T_qualifs_qlf
GROUP BY CUBE(cmp_compa,avi_typavi);

SELECT   cmp_compa,avi_typavi,qlf_annee,COUNT(qlf_brevet) AS "Pilotes"
FROM     T_qualifs_qlf
GROUP BY CUBE(cmp_compa,avi_typavi,qlf_annee);

-- GROUP BY GROUPING SETS( CUBE(expression [,...])
-- GROUP BY GROUPING SETS( ROLLUP(expression[,...]))
-- GROUP BY GROUPING SETS( ())

SELECT   cmp_compa,avi_typavi,qlf_annee,COUNT(qlf_brevet) AS "Pilotes"
FROM     T_qualifs_qlf
GROUP BY GROUPING SETS((cmp_compa,avi_typavi),qlf_annee,());

-- limites


/*

SELECT   cmp_compa,avi_typavi,COUNT(qlf_brevet) AS "Pilotes"
FROM     T_qualifs_qlf
GROUP BY CUBE(cmp_compa,avi_typavi,cmp_compa,avi_typavi,
              cmp_compa,avi_typavi,cmp_compa,avi_typavi,
              cmp_compa,avi_typavi,cmp_compa,avi_typavi,avi_typavi);

*/

DROP TABLE T_qualifs_qlf;

-- Analytiques

USE      BD_Air_France;

CREATE TABLE T_qualifs_qlf
 (qlf_brevet VARCHAR(6), qlf_annee DECIMAL(4,0),
  avi_typavi VARCHAR(4), qlf_hvol  DECIMAL(5,2));

INSERT INTO T_qualifs_qlf VALUES ('PL-1',2009,'A320',200.50);
INSERT INTO T_qualifs_qlf VALUES ('PL-1',2009,'A330',300);
INSERT INTO T_qualifs_qlf VALUES ('PL-1',2009,'A340',158.50);

INSERT INTO T_qualifs_qlf VALUES ('PL-1',2010,'A330',456);
INSERT INTO T_qualifs_qlf VALUES ('PL-1',2010,'A340',251);

INSERT INTO T_qualifs_qlf VALUES ('PL-1',2011,'A380',169.20);
INSERT INTO T_qualifs_qlf VALUES ('PL-1',2011,'A330',450.30);
INSERT INTO T_qualifs_qlf VALUES ('PL-1',2011,'A340',148);

INSERT INTO T_qualifs_qlf VALUES ('PL-2',2009,'A320',500.30);
INSERT INTO T_qualifs_qlf VALUES ('PL-2',2009,'A340',120);

INSERT INTO T_qualifs_qlf VALUES ('PL-2',2010,'A320',780);

INSERT INTO T_qualifs_qlf VALUES ('PL-2',2011,'A320',520.50);

INSERT INTO T_qualifs_qlf VALUES ('PL-3',2009,'A320',600.20);
INSERT INTO T_qualifs_qlf VALUES ('PL-3',2009,'A330',100.50);

INSERT INTO T_qualifs_qlf VALUES ('PL-3',2010,'A330',150);
INSERT INTO T_qualifs_qlf VALUES ('PL-3',2010,'A340',200.60);

INSERT INTO T_qualifs_qlf VALUES ('PL-3',2011,'A380',290);


INSERT INTO T_qualifs_qlf VALUES ('PL-4',2007,'A380',90);

INSERT INTO T_qualifs_qlf VALUES ('PL-4',2009,'A380',800);
INSERT INTO T_qualifs_qlf VALUES ('PL-4',2009,'B777',200);

INSERT INTO T_qualifs_qlf VALUES ('PL-4',2011,'A380',900);

-- OVER

-- avec des fct agrgats

SELECT avi_typavi,qlf_annee,qlf_brevet
    ,SUM(qlf_hvol)     OVER(PARTITION BY avi_typavi,qlf_annee) AS "Total h"
    ,AVG(qlf_hvol)     OVER(PARTITION BY qlf_annee)  AS "Moyenne anne"
    ,AVG(qlf_hvol)     OVER(PARTITION BY avi_typavi,qlf_annee)  AS "Moyenne anne/avion"
	,COUNT(qlf_brevet) OVER(PARTITION BY avi_typavi,qlf_annee) AS "Pilotes"
    ,MIN(qlf_hvol)     OVER(PARTITION BY avi_typavi) AS "Min"
    ,MAX(qlf_hvol)     OVER(PARTITION BY avi_typavi) AS "Max"
FROM T_qualifs_qlf;


-- Ranking 

SELECT ROW_NUMBER() 
      OVER(PARTITION BY avi_typavi ORDER BY qlf_annee DESC) AS "ROW_NUMBER()",
     qlf_brevet,avi_typavi,qlf_annee
FROM T_qualifs_qlf;

SELECT RANK()
      OVER(PARTITION BY avi_typavi ORDER BY qlf_annee DESC) AS "RANK()",
      qlf_brevet,avi_typavi,qlf_annee
FROM  T_qualifs_qlf
WHERE avi_typavi = 'A380';

SELECT DENSERANK()
      OVER(PARTITION BY avi_typavi ORDER BY qlf_annee DESC) AS "DENSERANK()",
     qlf_brevet,avi_typavi,qlf_annee
FROM T_qualifs_qlf
WHERE avi_typavi = 'A380';

SELECT NTILE(4) 
      OVER(ORDER BY avi_typavi,qlf_hvol DESC) AS "NTILE",
     qlf_brevet,avi_typavi,qlf_hvol,qlf_annee
FROM T_qualifs_qlf;

SELECT TOP(3) WITH TIES
 RANK() OVER(PARTITION BY avi_typavi ORDER BY qlf_annee DESC) AS rang,
     qlf_brevet,avi_typavi,qlf_annee
FROM T_qualifs_qlf
ORDER BY rang;

-- analytiques

-- Valeur suivante dans le dataset :

SELECT 
       qlf_brevet,qlf_annee,avi_typavi,qlf_hvol,
       LEAD (qlf_hvol,1,0) OVER (PARTITION BY qlf_brevet,avi_typavi ORDER BY qlf_annee) AS "an+1",
       LEAD (qlf_hvol,2,0) OVER (PARTITION BY qlf_brevet,avi_typavi ORDER BY qlf_annee) AS "an+2"
FROM   T_qualifs_qlf;

/*
WHERE  NOT (
       LEAD (qlf_hvol,1,0) OVER (PARTITION BY qlf_brevet,avi_typavi ORDER BY qlf_annee) = 0
AND    LEAD (qlf_hvol,2,0) OVER (PARTITION BY qlf_brevet,avi_typavi ORDER BY qlf_annee) = 0);

--> SELECT dans le FROM pour anuller certains
WHERE  NOT (hvol1 = 0 AND hvol2 = 0);
*/


-- Valeur prcdente dans le dataset :

SELECT 
       qlf_brevet,qlf_annee,avi_typavi,qlf_hvol,
       LAG(qlf_hvol,1,0) OVER (PARTITION BY qlf_brevet,avi_typavi ORDER BY qlf_annee ASC) AS "an-1",
       LAG(qlf_hvol,2,0) OVER (PARTITION BY qlf_brevet,avi_typavi ORDER BY qlf_annee ASC) AS "an-2"
FROM   T_qualifs_qlf;

-- Premire valeur dans un dataset

SELECT 
     DISTINCT qlf_brevet,avi_typavi,
     FIRST_VALUE(qlf_annee) OVER (PARTITION BY qlf_brevet,avi_typavi ORDER BY qlf_hvol) AS "Anne +faible",
     FIRST_VALUE(qlf_hvol) OVER (PARTITION BY qlf_brevet,avi_typavi ORDER BY qlf_hvol) AS "Heure vol"
FROM   T_qualifs_qlf;

-- dernire valeur dans un dataset

SELECT 
     DISTINCT qlf_brevet,avi_typavi,
     LAST_VALUE(qlf_annee)  
          OVER (PARTITION BY qlf_brevet,avi_typavi ORDER BY qlf_hvol 
                RANGE BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING) AS "Anne +forte",
     LAST_VALUE(qlf_hvol)  
          OVER (PARTITION BY qlf_brevet,avi_typavi ORDER BY qlf_hvol
                RANGE BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING) AS "Heure vol"
FROM   T_qualifs_qlf;

-- Partie de cumul de dataset

SELECT 
     qlf_brevet,avi_typavi,qlf_annee,qlf_hvol,
     CUME_DIST() OVER(PARTITION BY avi_typavi ORDER BY qlf_hvol) AS "CUME_DIST"
FROM   T_qualifs_qlf
ORDER BY 5 DESC;


--INTERSECT 

SELECT   qlf_brevet FROM T_qualifs_qlf WHERE avi_typavi='A320'
INTERSECT 
SELECT   qlf_brevet FROM T_qualifs_qlf WHERE avi_typavi='A340';


SELECT   qlf_brevet FROM T_qualifs_qlf 
WHERE avi_typavi='A320' AND qlf_annee = 2009
INTERSECT 
SELECT   qlf_brevet FROM T_qualifs_qlf WHERE avi_typavi='A340'
AND qlf_annee = 2009;


DROP TABLE T_qualifs_qlf; 

DROP TABLE T_pilote_pil;
GO
